package complex_operations;

import db_context.DbContext;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class PayRise {
    private static final PayRise INSTANCE = new PayRise();
    public static PayRise getInstance() {
        return INSTANCE;
    }
    private PayRise() {

    }

    public void RiseDriverSalaries() throws SQLException {
        DbContext.getConnection().setTransactionIsolation(Connection.TRANSACTION_REPEATABLE_READ);
        DbContext.getConnection().setAutoCommit(false);
        try {
            SQLLock();
            SQLQuery();
            DbContext.getConnection().commit();
            System.out.println("Salaries were risen");
        }catch (Exception e){
            DbContext.getConnection().rollback();
            System.out.println(e);
        }finally {
            DbContext.getConnection().setAutoCommit(true);
        }
    }

    public void SQLLock() throws SQLException {
        try(PreparedStatement s = DbContext.getConnection().prepareStatement("lock drivers in exclusive mode")){
            s.execute();
        }
    }

    public void SQLQuery() throws SQLException {
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("" +
                "update drivers set salary = initial_salary * pow(1.1, delivered_packages/10000 + (current_date - hire_date)/365)")){
            s.executeUpdate();
        }
    }
}
